/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.event;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.momosoftworks.coldsweat.api.temperature.modifier.WaterTempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.math.Vec2f;
import com.momosoftworks.coldsweat.util.math.Vec2i;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import oshi.util.tuples.Triplet;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class WetnessRenderer {
    private static final ResourceLocation WATER_DROP = new ResourceLocation("cold_sweat", "textures/gui/overlay/droplet.png");
    private static final ResourceLocation WATER_DROP_TRAIL = new ResourceLocation("cold_sweat", "textures/gui/overlay/droplet_trail.png");
    private static final List<Droplet> WATER_DROPS = new ArrayList<Droplet>();
    private static final List<Triplet<Vec2i, Float, Integer>> TRAILS = new ArrayList<Triplet<Vec2i, Float, Integer>>();
    private static boolean WAS_SUBMERGED = false;

    @SubscribeEvent
    public static void updateSkyBrightness(TickEvent.ClientTickEvent event) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            level.m_46465_();
        }
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiEvent.Pre event) {
        int size;
        int i;
        boolean justExitedWater;
        LocalPlayer player;
        if (!ConfigSettings.SHOW_WATER_EFFECT.get().booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        PoseStack ps = event.getPoseStack();
        float frametime = mc.m_91297_();
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        boolean paused = mc.m_91104_();
        int uiScale = (Integer)mc.f_91066_.m_231928_().m_231551_();
        if (uiScale == 0) {
            uiScale = mc.m_91268_().m_85385_(0, mc.m_91390_());
        }
        if ((player = mc.f_91074_) == null) {
            return;
        }
        BlockPos playerPos = player.m_20183_();
        float playerYVelocity = (float)(player.m_20182_().f_82480_ - player.f_19791_);
        boolean isSubmerged = player.canSwimInFluidType(player.getEyeInFluidType());
        int light = player.f_19853_.m_46803_(playerPos.m_7494_());
        if (player.m_21023_(MobEffects.f_19611_)) {
            light = 15;
        }
        float brightness = CSMath.blend(0.0f, 1.0f, light, 0.0f, 15.0f);
        float tempMult = (float)CSMath.blend(0.3, 6.0, Temperature.get((LivingEntity)player, Temperature.Trait.WORLD), ConfigSettings.MIN_TEMP.get(), ConfigSettings.MAX_TEMP.get() * 2.0);
        if (isSubmerged && !paused) {
            TRAILS.clear();
            for (Droplet drop : WATER_DROPS) {
                drop.alpha -= 0.6f * frametime;
                float xMoveDir = drop.position.x < (float)screenWidth / 2.0f ? -1.0f : 1.0f;
                float yMoveDir = drop.position.y < (float)screenHeight / 2.0f ? -1.0f : 1.0f;
                drop.position.add(new Vec2f(xMoveDir, yMoveDir).mul(200.0f * -playerYVelocity * frametime));
            }
        }
        double wetness = Temperature.getModifier((LivingEntity)mc.f_91074_, Temperature.Trait.WORLD, WaterTempModifier.class).map(arg_0 -> WetnessRenderer.lambda$onRenderOverlay$0((Player)player, arg_0)).orElse(0.0);
        boolean bl = justExitedWater = WAS_SUBMERGED && !isSubmerged;
        if (justExitedWater) {
            for (int i2 = 0; i2 < 15; ++i2) {
                Droplet newDrop = WetnessRenderer.createDrop(screenWidth, screenHeight);
                newDrop.yMotion = WetnessRenderer.getRandomVelocity(frametime) / 2.0f + 0.3f;
                newDrop.position.y = (float)Math.random() * (float)screenHeight;
                WATER_DROPS.add(newDrop);
                int streakLength = (int)(Math.random() * 5.0) + 5;
                int x = (int)newDrop.position.x;
                int y = (int)newDrop.position.y;
                for (int j = 1; j < streakLength; ++j) {
                    TRAILS.add((Triplet<Vec2i, Float, Integer>)new Triplet((Object)new Vec2i(x, y - j), (Object)Float.valueOf(CSMath.blend(newDrop.alpha * 0.8f, 0.0f, j, 1.0f, streakLength)), (Object)(newDrop.size / 2)));
                }
            }
        }
        WAS_SUBMERGED = isSubmerged;
        if (!paused && !isSubmerged && wetness > (double)0.01f && (double)((float)Math.random()) * 0.05 < (double)0.0015f * wetness * (double)(frametime * 2.0f)) {
            WATER_DROPS.add(WetnessRenderer.createDrop(screenWidth, screenHeight));
        }
        RenderSystem.m_157427_(GameRenderer::m_172820_);
        RenderSystem.m_69478_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)WATER_DROP);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        for (i = 0; i < WATER_DROPS.size(); ++i) {
            Droplet drop = WATER_DROPS.get(i);
            Vec2f pos = drop.position;
            float alpha = drop.alpha;
            size = drop.size / uiScale * 3;
            if (alpha > 0.0f) {
                WetnessRenderer.renderQuad(ps, bufferBuilder, (int)CSMath.roundNearest(pos.x, 3.0f / (float)uiScale), (int)pos.y, size, size, 0.0f, 0.0f, 1.0f, 1.0f, brightness, brightness, brightness, alpha);
                if (!paused) {
                    drop.alpha = wetness <= 0.0 ? (drop.alpha -= 0.08f * frametime) : (drop.alpha -= 0.003f * frametime * tempMult);
                    if (drop.yMotionUpdateCooldown <= 0.0f) {
                        drop.yMotionUpdateCooldown = (float)Math.random() * 16.0f + 8.0f;
                        drop.yMotion = WetnessRenderer.getRandomVelocity(frametime);
                    } else {
                        drop.yMotionUpdateCooldown -= frametime;
                    }
                    float dropMoveFromPlayerLook = -(player.f_20885_ - player.f_20886_) / 20.0f;
                    dropMoveFromPlayerLook = (float)CSMath.shrink(dropMoveFromPlayerLook, 0.5);
                    drop.xVelocity = (float)CSMath.maxAbs((double)dropMoveFromPlayerLook * (Math.random() * 0.2), drop.xVelocity);
                    drop.xVelocity /= 1.0f + 0.6f * frametime;
                    if (drop.XMotionUpdateCooldown <= 0.0f) {
                        drop.XMotionUpdateCooldown = (float)Math.random() * 8.0f + 4.0f;
                        drop.xMotion = (float)Math.random() * 0.02f - 0.01f;
                    }
                    drop.XMotionUpdateCooldown -= frametime;
                    int oldY = (int)pos.y;
                    if (!isSubmerged) {
                        drop.position.add(new Vec2f(drop.xMotion * drop.yMotion * 20.0f + drop.xVelocity, drop.yMotion).div(uiScale).mul(3.0f));
                    }
                    for (int j = 0; j < Math.max(0, (int)(pos.y - (float)oldY)); ++j) {
                        TRAILS.add((Triplet<Vec2i, Float, Integer>)new Triplet((Object)new Vec2i((int)pos.x, oldY + j), (Object)Float.valueOf(alpha), (Object)size));
                    }
                }
                if (pos.x < -20.0f) {
                    pos.x = screenWidth + 20;
                } else if (pos.x > (float)(screenWidth + 20)) {
                    pos.x = -20.0f;
                }
                if (!(pos.y > (float)screenHeight)) continue;
                WATER_DROPS.remove(drop);
                --i;
                continue;
            }
            WATER_DROPS.remove(drop);
            --i;
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)WATER_DROP_TRAIL);
        for (i = 0; i < TRAILS.size(); ++i) {
            Triplet<Vec2i, Float, Integer> trail = TRAILS.get(i);
            Vec2i pos = (Vec2i)trail.getA();
            float alpha = ((Float)trail.getB()).floatValue();
            size = (Integer)trail.getC();
            if (alpha > 0.0f) {
                WetnessRenderer.renderQuad(ps, bufferBuilder, (int)CSMath.roundNearest(pos.x, 3.0f / (float)uiScale * 4.0f), pos.y, size, 1, 0.0f, 0.0f, 1.0f, 1.0f, brightness, brightness, brightness, alpha);
                if (paused) continue;
                TRAILS.set(i, (Triplet<Vec2i, Float, Integer>)new Triplet((Object)new Vec2i(pos.x, pos.y), (Object)Float.valueOf(alpha - 0.045f * frametime), (Object)size));
                continue;
            }
            TRAILS.remove(trail);
            --i;
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
    }

    private static float getRandomVelocity(float frametime) {
        return (float)Math.min((double)(0.7f * frametime * 20.0f), Math.pow(Math.random() * 5.0 + (double)0.1f, 3.0) * (double)frametime / 4.0);
    }

    private static Droplet createDrop(int screenWidth, int screenHeight) {
        int size = new Random().nextInt(32, 40);
        return new Droplet(new Vec2f((int)(Math.random() * (double)screenWidth), -size), 1.0f, size);
    }

    private static void renderQuad(PoseStack poseStack, BufferBuilder bufferBuilder, int x, int y, int width, int height, float u, float v, float uWidth, float vHeight, float r, float g, float b, float a) {
        Matrix4f lastPose = poseStack.m_85850_().m_85861_();
        bufferBuilder.m_85982_(lastPose, (float)x, (float)y, 0.0f).m_7421_(u, v).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_85982_(lastPose, (float)x, (float)(y + height), 0.0f).m_7421_(u, v + vHeight).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_85982_(lastPose, (float)(x + width), (float)(y + height), 0.0f).m_7421_(u + uWidth, v + vHeight).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_85982_(lastPose, (float)(x + width), (float)y, 0.0f).m_7421_(u + uWidth, v).m_85950_(r, g, b, a).m_5752_();
    }

    private static /* synthetic */ Double lambda$onRenderOverlay$0(Player player, WaterTempModifier mod) {
        return CSMath.blend(0.0, 1.0, mod.getWetness(), 0.0, mod.getMaxStrength((LivingEntity)player));
    }

    protected static class Droplet {
        public Vec2f position;
        public float alpha;
        public int size;
        public float yMotion = (float)Math.random() * 0.05f + 0.05f;
        public float xMotion = (float)Math.random() * 0.02f - 0.01f;
        public float xVelocity = 0.0f;
        public float yMotionUpdateCooldown = (float)Math.random() * 16.0f + 8.0f;
        public float XMotionUpdateCooldown = 16.0f;

        public Droplet(Vec2f position, float alpha, int size) {
            this.position = position;
            this.alpha = alpha;
            this.size = size;
        }
    }
}

